#
# To run VASP this script calls $vasp_std
# (or posibly $vasp_gam and/or $vasp_ncl).
# These variables can be defined by sourcing vaspcmd
. vaspcmd 2> /dev/null

#
# When vaspcmd is not available and $vasp_std,
# $vasp_gam, and/or $vasp_ncl are not set as environment
# variables, you can specify them here
[ -z "`echo $vasp_std`" ] && vasp_std="mpirun -np 4 vasp"
[ -z "`echo $vasp_gam`" ] && vasp_gam="mpirun -np 4 vasp_g"
[ -z "`echo $vasp_ncl`" ] && vasp_ncl="mpirun -np 4 vasp_ncl"
#
# The real work starts here
#

echo "
#
# PBE ground state energy 
#
"
rm WAVECAR
cp INCAR.DFT INCAR
vasp_std 4
echo "
#
# increase number of bands
#
"
cp INCAR.PBE INCAR
vasp_std 4
cp OUTCAR OUTCAR.PBE
cp WAVECAR WAVECAR.PBE
cp WAVEDER WAVEDER.PBE
cp CHGCAR CHGCAR.PBE

echo "
#------------------------------------------------------------------------
# CRPA 
#------------------------------------------------------------------------
# calculate CRPA interaction at omega=0
#
"
cp WAVECAR.PBE WAVECAR
cp WAVEDER.PBE WAVEDER
cp INCAR.CRPA INCAR
vasp_std 4
cp OUTCAR OUTCAR.CRPA
echo "
#
# compute CRPA interaction on imaginary frequency axis
#
"
cp INCAR.CRPAR INCAR
vasp_std 4
cp OUTCAR OUTCAR.CRPAR

echo "
#
# compute off-centre Coulomb integrals at omega=0 
# requries WFULLxxxx.tmp files from cRPA step!
#
"
cp INCAR.2E4WA INCAR
vasp_std 4
cp OUTCAR OUTCAR.2E4WA
