#
# To run VASP this script calls $vasp_std
# (or posibly $vasp_gam and/or $vasp_ncl).
# These variables can be defined by sourcing vaspcmd
. vaspcmd 2> /dev/null

#
# When vaspcmd is not available and $vasp_std,
# $vasp_gam, and/or $vasp_ncl are not set as environment
# variables, you can specify them here
[ -z "`echo $vasp_std`" ] && vasp_std="mpirun -np 8 /path-to-your-vasp/vasp_std"
[ -z "`echo $vasp_gam`" ] && vasp_gam="mpirun -np 8 /path-to-your-vasp/vasp_gam"
[ -z "`echo $vasp_ncl`" ] && vasp_ncl="mpirun -np 8 /path-to-your-vasp/vasp_ncl"

#
# The real work starts here
#

for i in  5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 ; do

cat >POSCAR <<!
system Si
  $i
0.5 0.5 0.0
0.0 0.5 0.5
0.5 0.0 0.5
2
cart
0.00 0.00 0.00
0.25 0.25 0.25
!

# start with a PBE calculation with a lot of k-points (needed for EXX)
rm WAVECAR WAVEDER
cp KPOINTS.12 KPOINTS
cp INCAR.DFT INCAR
$vasp_std

cp OUTCAR OUTCAR.DFT.$i
e1=`awk '/free  energy/ {print $5}' OUTCAR`

# get the HF energy with PBE orbitals
cp INCAR.EXX INCAR
$vasp_std
e2=`awk '/free  energy/ {print $5}' OUTCAR`

cp OUTCAR OUTCAR.EXX.$i

# now a PBE calculation with less k-points
rm WAVECAR WAVEDER
cp KPOINTS.6 KPOINTS
cp INCAR.DFT INCAR
$vasp_std

# obtain virtual orbitals
cp INCAR.DIAG INCAR
$vasp_std

cp OUTCAR OUTCAR.DIAG.$i
cp WAVECAR WAVECAR.$i
cp WAVEDER WAVEDER.$i

## for metals
# cp INCAR.HFC INCAR
# $vasp_std
#
# cp OUTCAR OUTCAR.HFC.$i
# e3=`awk '/HF-correction/ {print $4}' OUTCAR`

# RPA correlation
cp INCAR.ACFDT INCAR
$vasp_std

cp OUTCAR OUTCAR.ACFDT.$i
e4=`awk '/converged value/ {print $3}' OUTCAR`

# echo $i $e1 $e2 $e3 $e4 >> summary
echo $i $e1 $e2 $e4 >> summary

done
