#
# To run VASP this script calls $vasp_std
# (or posibly $vasp_gam and/or $vasp_ncl).
# These variables can be defined by sourcing vaspcmd
. vaspcmd 2> /dev/null

#
# When vaspcmd is not available and $vasp_std,
# $vasp_gam, and/or $vasp_ncl are not set as environment
# variables, you can specify them here
[ -z "`echo $vasp_std`" ] && vasp_std="mpirun -np 8 /path-to-your-vasp/vasp_std"
[ -z "`echo $vasp_gam`" ] && vasp_gam="mpirun -np 8 /path-to-your-vasp/vasp_gam"
[ -z "`echo $vasp_ncl`" ] && vasp_ncl="mpirun -np 8 /path-to-your-vasp/vasp_ncl"

#
# The real work starts here
#

# Here the work starts
NKPTS=4 

for NKPTS in 4 6 8 # 10 12
do

  cat >KPOINTS <<!
Automatically generated mesh
       0
Gamma
  $NKPTS $NKPTS $NKPTS
!


rm WAVECAR* WAVEDER*

cp INCAR.DFT INCAR
$vasp_std
cp OUTCAR OUTCAR.DFT.$NKPTS
cp vasprun.xml vasprun.DFT.$NKPTS.xml
./extract_optics.sh
mv optics.dat optics.DFT.$NKPTS.dat

cp INCAR.mBSE INCAR
$vasp_std
cp OUTCAR OUTCAR.mBSE.$NKPTS
cp vasprun.xml vasprun.mBSE.$NKPTS.xml
./extract_optics.sh
mv optics.dat optics.mBSE.$NKPTS.dat

done
