#
# To run VASP this script calls $vasp_std
# (or posibly $vasp_gam and/or $vasp_ncl).
# These variables can be defined by sourcing vaspcmd
. vaspcmd 2> /dev/null

#
# When vaspcmd is not available and $vasp_std,
# $vasp_gam, and/or $vasp_ncl are not set as environment
# variables, you can specify them here
[ -z "`echo $vasp_std`" ] && vasp_std="mpirun -np 8 /path-to-your-vasp/vasp_std"
[ -z "`echo $vasp_gam`" ] && vasp_gam="mpirun -np 8 /path-to-your-vasp/vasp_gam"
[ -z "`echo $vasp_ncl`" ] && vasp_ncl="mpirun -np 8 /path-to-your-vasp/vasp_ncl"

#
# The real work starts here
#

data[1]="0.000000  0.000000  0.000000"     
data[2]="0.250000 -0.000000  0.000000"     
data[3]="0.500000 -0.000000  0.000000"     
data[4]="0.250000  0.250000  0.000000"     
data[5]="0.500000  0.250000  0.00000"    
data[6]="-0.250000  0.250000  0.00000" 
data[7]="0.500000  0.500000  0.000000" 
data[8]="-0.250000  0.500000  0.250000"

NKPT=4 #choose the grid density for which to perfom 8 INDEPENDENT calculations 
for i in 1 2 3 4 5 6 7 8
do

  cat >KPOINTS <<!
Automatically generated mesh
       0
Gamma
  $NKPT $NKPT $NKPT
${data[$i]}
!


rm WAVECAR* WAVEDER*

cp INCAR.DFT INCAR
$vasp_std
cp OUTCAR OUTCAR.DFT.$NKPT.$i
cp vasprun.xml vasprun.DFT.$NKPT.$i.xml

cp INCAR.DIAG INCAR
$vasp_std
cp OUTCAR OUTCAR.DIAG
cp vasprun.xml vasprun.DIAG.$NKPT.$i.xml
./extract_optics.sh
mv optics.dat optics.DFT.$NKPT.$i.dat

cp INCAR.GW0 INCAR
$vasp_std
cp OUTCAR OUTCAR.GW0.$NKPT.$i
cp vasprun.xml vasprun.GW0.$NKPT.$i.xml

cp INCAR.NONE INCAR
$vasp_std
cp OUTCAR OUTCAR.NONE.$NKPT.$i
cp vasprun.xml vasprun.NONE.$NKPT.$i.xml
./extract_optics.sh
mv optics.dat optics.RPA.$NKPT.$i.dat

cp INCAR.BSE INCAR
$vasp_std
cp OUTCAR OUTCAR.BSE.$NKPT.$i
cp vasprun.xml vasprun.BSE.$NKPT.$i.xml
./extract_optics.sh
mv optics.dat optics.BSE.$NKPT.$i.dat

done

#post processing of the spectra
# Kpoint weights IBZ gamma centered 4x4x4 mesh

data[1]="1.00000"     
data[2]="8.00000"     
data[3]="4.00000"     
data[4]="6.00000"     
data[5]="24.00000"     
data[6]="12.00000"     
data[7]="3.00000"     
data[8]="6.00000"     
sum=64

rm dieTMP.*
for i in 1 2 3 4 5 6 7 8
do
awk < optics.DFT.$NKPT.$i.dat -v wg="${data[$i]}" '{print $1,$2*wg,$3*wg}' >> dieTMP.$i
done
paste -d " " dieTMP.* | awk '{print $1, ($2+$5+$8+$11+$14+$17+$20+$23)/64,($3+$6+$9+$12+$15+$18+$21+$24)/64}' > average_die.DFT.$NKPT.dat

rm dieTMP.*
for i in 1 2 3 4 5 6 7 8
do
awk < optics.RPA.$NKPT.$i.dat -v wg="${data[$i]}" '{print $1,$2*wg,$3*wg}' >> dieTMP.$i
done
paste -d " " dieTMP.* | awk '{print $1, ($2+$5+$8+$11+$14+$17+$20+$23)/64,($3+$6+$9+$12+$15+$18+$21+$24)/64}' > average_die.RPA.$NKPT.dat

rm dieTMP.*
for i in 1 2 3 4 5 6 7 8
do
awk < optics.BSE.$NKPT.$i.dat -v wg="${data[$i]}" '{print $1,$2*wg,$3*wg}' >> dieTMP.$i
done
paste -d " " dieTMP.* | awk '{print $1, ($2+$5+$8+$11+$14+$17+$20+$23)/64,($3+$6+$9+$12+$15+$18+$21+$24)/64}' > average_die.BSE.$NKPT.dat

rm dieTMP.*

