#
# To run VASP this script calls $vasp_std
# (or posibly $vasp_gam and/or $vasp_ncl).
# These variables can be defined by sourcing vaspcmd
. vaspcmd 2> /dev/null

#
# When vaspcmd is not available and $vasp_std,
# $vasp_gam, and/or $vasp_ncl are not set as environment
# variables, you can specify them here
[ -z "`echo $vasp_std`" ] && vasp_std="mpirun -np 8 /path-to-your-vasp/vasp_std"
[ -z "`echo $vasp_gam`" ] && vasp_gam="mpirun -np 8 /path-to-your-vasp/vasp_gam"
[ -z "`echo $vasp_ncl`" ] && vasp_ncl="mpirun -np 8 /path-to-your-vasp/vasp_ncl"

#
# The real work starts here
#

cp KPOINTS.6 KPOINTS

rm WAVECAR* WAVEDER*

cp INCAR.DFT INCAR
$vasp_std
cp OUTCAR OUTCAR.DFT
cp vasprun.xml vasprun.DFT.xml

cp INCAR.DIAG INCAR
$vasp_std
cp OUTCAR OUTCAR.DIAG
cp vasprun.xml vasprun.DIAG.xml
./extract_optics.sh
mv optics.dat optics.DFT.dat

# cp WAVECAR WAVECAR.chi
# cp WAVEDER WAVEDER.chi
# cp INCAR.scGW0 INCAR
# $vasp_std
# cp OUTCAR OUTCAR.scGW0
# cp vasprun.xml vasprun.scGW0.xml

cp INCAR.GW0 INCAR
$vasp_std
cp OUTCAR OUTCAR.GW0
cp vasprun.xml vasprun.GW0.xml

cp INCAR.NONE INCAR
$vasp_std
cp OUTCAR OUTCAR.NONE
cp vasprun.xml vasprun.NONE.xml
./extract_optics.sh
mv optics.dat optics.RPA.dat

cp INCAR.BSE INCAR
$vasp_std
cp OUTCAR OUTCAR.BSE
cp vasprun.xml vasprun.BSE.xml
./extract_optics.sh
mv optics.dat optics.BSE.dat
