#!/bin/bash 

if [ -f gap_vs_temp.dat ]
then
   rm gap_vs_temp.dat
fi

touch gap_vs_temp.dat
counter=0

for temp in 0 100 200 300 400 500 600 700
do
   i="OUTCAR.T=$temp"

   homo1=`awk '/NELECT/ {print $3/2}' $i`
   homo2=`awk '/NELECT/ {print $3/2-1}' $i`
   homo3=`awk '/NELECT/ {print $3/2-2}' $i`
   lumo1=`awk '/NELECT/ {print $3/2+var+1}' $i`
   lumo2=`awk '/NELECT/ {print $3/2+var+2}' $i`
   lumo3=`awk '/NELECT/ {print $3/2+var+3}' $i`
   lumo4=`awk '/NELECT/ {print $3/2+var+4}' $i`
   lumo5=`awk '/NELECT/ {print $3/2+var+5}' $i`
   lumo6=`awk '/NELECT/ {print $3/2+var+6}' $i`
   e1a=`grep "^    $homo1   " $i | head -$nkpt | sort -n -k 2 | tail -1 | awk '{print $2}'`
   e1b=`grep "^    $homo2   " $i | head -$nkpt | sort -n -k 2 | tail -1 | awk '{print $2}'`
   e1c=`grep "^    $homo3   " $i | head -$nkpt | sort -n -k 2 | tail -1 | awk '{print $2}'`
   e2a=`grep "^    $lumo1   " $i | head -$nkpt | sort -n -k 2 | head -1 | awk '{print $2}'`
   e2b=`grep "^    $lumo2   " $i | head -$nkpt | sort -n -k 2 | head -1 | awk '{print $2}'`
   e2c=`grep "^    $lumo3   " $i | head -$nkpt | sort -n -k 2 | head -1 | awk '{print $2}'`
   e2d=`grep "^    $lumo4   " $i | head -$nkpt | sort -n -k 2 | head -1 | awk '{print $2}'`
   e2e=`grep "^    $lumo5   " $i | head -$nkpt | sort -n -k 2 | head -1 | awk '{print $2}'`
   e2f=`grep "^    $lumo6   " $i | head -$nkpt | sort -n -k 2 | head -1 | awk '{print $2}'`   

   if [ $temp -eq "0" ]
   then
      ref=`echo "$e1a $e1b $e1c $e2a $e2b $e2c $e2d $e2e $e2f" |awk '{print (($4+$5+$6+$7+$8+$9)/6.0-($1+$2+$3)/3.0)}'`
   fi

   echo "$e1a $e1b $e1c $e2a $e2b $e2c $e2d $e2e $e2f $temp $ref" |awk '{print $10,(($4+$5+$6+$7+$8+$9)/6.0-($1+$2+$3)/3.0)-$11}' >> gap_vs_temp.dat
done
