#!/bin/bash

for i in OUTTEMP_*
do
   cp $i OUTTEMP.current 
   #extract temperature
   temp=`head -n 1 OUTTEMP.current|awk '{print $3}'`
   #do fitting
   gnuplot -e "E(V)=E0+9.0/8.0*B0*V0*((V0/V)**(2.0/3.0)-1)**2 + 9.0/16.0*B0*\
      (B0P-4)*V0*((V0/V)**(2.0/3.0)-1.0)**3.0 + R*((V0/V)**(2.0/3.0)-1.0)**4.0;\
      B0P = 1;B0 = 1;V0 = 720;E0 = -1150;R  = -1.0;fit E(x) 'OUTTEMP.current'  u 1:2 via B0P,B0,V0,E0,R" &> suppress_output
   #extract volume from fit
   a=`grep "V0" fit.log|grep "=" |tail -n 1|awk '{print ($3/2.0)**(1.0/3.0)}'` 
   #print temperature and volume to 
   echo "temperature: $temp, a_latt: $a" 
done

rm suppress_output
rm OUTTEMP.current
