#!/bin/bash

bandshift=0
gwrun=-1
dgbd=-1
val=-1
con=-1
gwldadiff=-1
test=-1
while [[ $# -gt 0 ]]
do
   key="$1"
   case $key in
   esac
   shift
done

if [ -f "helpscript.perl" ]; then
   rm helpscript.perl
fi


cat > helpscript.perl  <<EOF
#!/bin/perl

use strict;
use warnings;

my \$zahler=0;
my @entropy=0;
my \$ezp=0;
my \$fhelmholtz=0;
my \$uenergy;
my \$kboltzmann=8.6173303*10**(-5.0);
my \$ntemp=8;
my \$tmax=700;
my \$tmin=0;
my \$tstep=100;
for (my \$itemp=1;\$itemp<=\$ntemp;\$itemp++)
{
   \$entropy[\$itemp]=0;
}
while (<>)
{
   chomp;
   \$_=~s/^/ /;
   my @help=split(/[\t,\s]+/);
   \$zahler=\$zahler+1;
   if (\$zahler == 1) {\$uenergy=\$help[1];}
   else 
   {
      my \$homega=\$help[2]/1000;
      \$ezp=\$ezp+\$homega*0.5;
      for (my \$itemp=1;\$itemp<=\$ntemp;\$itemp++)
      {
         my \$temp=(\$itemp-1)*\$tstep+\$tmin;
         my \$kbt=\$kboltzmann*\$temp;
         if (\$temp < 0.0000001) 
         {
         }
         else
         {
              \$entropy[\$itemp]=\$entropy[\$itemp]-\$kboltzmann*log(1-exp(-\$homega/\$kbt));
              \$entropy[\$itemp]=\$entropy[\$itemp]+\$kboltzmann*\$homega/\$kbt*(1/(exp(\$homega/\$kbt)-1));
         }
      }
   }
   last if eof;
}

\$ezp=\$ezp; #/ \$zahler;

for (my \$itemp=1;\$itemp<=\$ntemp;\$itemp++)
{
    my \$temp=(\$itemp-1)*\$tstep+\$tmin;
        
    \$entropy[\$itemp]=\$entropy[\$itemp]; # / \$zahler; 
    \$fhelmholtz=\$uenergy+\$ezp-\$temp*\$entropy[\$itemp];
    printf ("%15.8e %15.8e\n",\$temp,\$fhelmholtz);
}
printf ("#NOTEMP %15.8e\n",\$uenergy);
EOF

rm OUTTEMP*
first=0
for i in OUTCAR_*; do

   echo "Starting $i"
   v2=${i##OUTCAR_}
   if [ -f "helpfile.help" ]; then
      rm helpfile.help
   fi
   touch helpfile.help
   cp OUTCAR_$v2 OUTCAR
   awk '/free energy/' OUTCAR | tail -n 1| awk '{print $5}' >> helpfile.help
   awk '/[0-9]* f .* THz/ {print $1,$10}' OUTCAR >> helpfile.help
   awk '/[0-9]* f.i.*THz/ {print $1,$9}' OUTCAR >> helpfile.help
   volume=`awk '/volume of cell/ {print $5}' OUTCAR | tail -n 1`

   perl helpscript.perl helpfile.help > hhhhelp.txt
  
   runcount=0
   while read line; do 
      runcount=$((runcount+1))
      if [[ $first -eq 0 ]]; then
         echo $line | awk -v var="$volume" '{print var,$2,$1}' > OUTTEMP_$runcount
      else
         echo $line | awk -v var="$volume" '{print var,$2}' >> OUTTEMP_$runcount
      fi
   done < ./hhhhelp.txt

   first=1
done

for i in OUTTEMP_*; do
   v2=${i##OUTTEMP_}
   mv OUTTEMP_$v2 OUTHELP
   sort -n -k 1 OUTHELP > OUTTEMP_$v2
done

rm helpfile.help
rm helpscript.perl
rm hhhhelp.txt
rm OUTHELP
