#!/usr/bin/python

import sys
import re
import math

#setting grid for histogram
xmin=0.0
xmax=5.0
nx=500
dx=(xmax-xmin)/nx
histogram=[0.0 for j in range(0,nx)]
readfile = open("timeEvol.dat","r")
line=readfile.readline()
z=0
ymin=0.0
ymax=0.0
#loop over lines in file timeEvol.dat
while (line):
  z=z+1
  line.strip()
  line=re.sub('^',' ',line)
  y=line.split()
  if (z==1):
     ymin=float(y[0])
     ymax=float(y[0])
  #calculate min max value for normalization
  if (ymin>float(y[0])): 
     ymin=float(y[0])
  if (ymax<float(y[0])):
     ymax=float(y[0])
  #calculate index of argument
  ix=int(float(y[0])/float(dx)+0.5)
  #check for segmentation fault
  if (ix>=0 and ix<nx):
     histogram[ix]=histogram[ix]+1.0
  line=readfile.readline()
readfile.close
#normalizing and printing histogram
norm=z*(abs(xmax-xmin))/nx
for ix in range(0,nx):
   x=xmin+ix*dx
   pair_cor=histogram[ix]/norm
   print x, pair_cor
