#
# To run VASP this script calls $vasp_std
# (or posibly $vasp_gam and/or $vasp_ncl).
# These variables can be defined by sourcing vaspcmd
. vaspcmd 2> /dev/null

#
# When vaspcmd is not available and $vasp_std,
# $vasp_gam, and/or $vasp_ncl are not set as environment
# variables, you can specify them here
[ -z "`echo $vasp_std`" ] && vasp_std="mpirun -np 8 /path-to-your-vasp/vasp_std"
[ -z "`echo $vasp_gam`" ] && vasp_gam="mpirun -np 8 /path-to-your-vasp/vasp_gam"
[ -z "`echo $vasp_ncl`" ] && vasp_ncl="mpirun -np 8 /path-to-your-vasp/vasp_ncl"

#
# The real work starts here
#

# Here the work starts
rm results.dat

drct=$(pwd)

for i in graphene graphite
do
  cd $drct/$i
  $vasp_std
done

cd $drct

# obtain total energy for graphite 
en2=$(grep "free  ene" graphite/OUTCAR |tail -1|awk '{print $5}') 

# obtain total energy for graphene
en1=$(grep "free  ene" graphene/OUTCAR |tail -1|awk '{print $5}')

# compute interlayer binding energy (eV/atom)
deltaE=$(echo print $en2/4 - $en1/2 |python)

echo "Binding energy (eV/atom): " $deltaE >results.dat
