#!/usr/bin/python
from numpy import *
import cPickle
import random
import takeinp
import abstracts


def calcVel(xi, xj):
    v = xi-xj
    for i in range(len(v)):
        for j in range(3):
            while v[i][j] > 0.5:
                v[i][j] -= 1.0
            while v[i][j] <= -0.5:
                v[i][j] += 1.0
    return v


cfile = 'trajectory.dat'
ufile = open(cfile, 'r')
xdat = cPickle.load(ufile)
ufile.close()

nsw = len(xdat)
inpt = takeinp.TakeInput('POSCAR')
lattmat = inpt.lattmat

cros = random.randint(0, nsw-1)
x = array(xdat[cros])
v = calcVel(x, array(xdat[cros-1]))
x_ = x-v
print cros
abstracts.write_poscar('POSCAR.f', x, v, lattmat)
abstracts.write_incar('INCAR.f', cros)
