#!/bin/bash

#script zetBM.sh
#	- as the script fgradBM.sh but average |z|^(-1/2) 
#	instead of free energy gradients are computed for each integration point 

drct=$(pwd)
  
#c equilibration period
equil=500

j=-1

for i in 1 2 3 4 5 6 7
do
  if test -d  $i
  then
    let j+=1
    cd $i

    if test -f report.all
    then
      rm report.all
    fi


    #c collect the BM output from all REPORT files
    k=1
    while [ $k -le 100 ]
    do
      if test -f report.$k
      then
        grep b_m report.$k >>report.all
      fi
      let k=k+1
    done

    #c identify the value of \xi
    x1=$(grep cc report.1|head -1|awk '{print $3}')
    
    nlines=$(wc -l report.all|awk '{print $1}')
    let prod=nlines-equil

    zet=$(grep b_m report.all|tail -$prod |awk 'BEGIN {a=0.} {a+=$3} END {print a/NR}')

    echo $x1 $zet

    cd $drct
  
  fi

done

