#!/usr/bin/bash

#script aux_vel.sh
#	- computes value of |xidot| using report.* files from MD with a single 
#	constraint. It is assumed that the script is exectuted from the 
#	subdirectory corresponding to the integration point for which |xidot| is to
#	be computed.

T=$1

rm tmp.tmp

i=1
while [ $i -le 500 ]
do
  if test -f report.$i
  then
    grep b_m report.$i |awk '{print $3}' >> tmp.tmp 
  fi
  let i=i+1
done


#c unbiased absolute value of velocity
vAbs_u=$(awk 'BEGIN {t="'${T}'";a=0.;b=0.;f=(1.323296617200639e+23*t)**0.5} {a+=$1*$1;b+=$1} END {a/=NR;b/=NR;print 2*f/b,"[unit]/s"}' tmp.tmp )


echo $vAbs_u
