#!/usr/bin/bash

#script ircShift.sh
#	- extracts potential energy profile (eV) along length of path (\AA) taken along IRC. 
#	Note that, by convention, the lenght of path is taken negative for the 
#	IRC_DIRECTION = -1 branch. 
#
#	- script assumes that m/OUTCAR and p/OUTCAR exist that contain results of IRC calculation 
#	with IRC_DIRECTION = -1 and 1, respectively

e0=$(grep "IRC (A):" m/OUTCAR|awk '{print $5}'|head -1)

grep "IRC (A):" m/OUTCAR|awk '{print $3,$5 - "'${e0}'"}' >tmp.tmp
grep "IRC (A):" p/OUTCAR|awk '{print $3,$5 - "'${e0}'"}' >>tmp.tmp

sort -n tmp.tmp >ircShift.dat
