#!/bin/bash

#script fgrad.sh
#        - extracts \xi and approximation to free energy gradients from report.* files 
#	obtained in slow growth simulation. The script assumes the report.* files 
#	are located in directory from which it is executed. The result is stored in 
#	file grad.dat


rm grad.dat

i=1

while [ $i -le 1000 ]
do
  if test -f report.$i
  then
    grep cc report.$i |awk '{print $3}' >xxx
    grep b_m report.$i |awk '{print $2}' >fff
    paste xxx fff >> grad.dat
  fi
  let i=i+1
done


sort -n grad.dat >grad_.dat
mv grad_.dat grad.dat
