#!/bin/bash 

file="vasprun.xml"
outfile="dielectric_function.dat"

echo "Extracting dielectric function from " $file
awk '
/<dielectricfunction comment="density-density"/ { on=1 }
on==1 && /<r>/ { print $2,($3+$4+$5)/3 } 
on==1 && /<real>/ { print " " }
on==1 && /<imag>/ { print " " }
/<\/dielectricfunction/ { on=0 }
' < $file  > $outfile

echo "Data written to " $outfile

